       LIST

        NOLIST


;==========================================================================
;
;       Verify Processor
;
;==========================================================================
        IFNDEF __18F08
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;       18Fxxx Family        EQUates
;==========================================================================

;==========================================================================

;==========================================================================
;       16Cxxx/17Cxxx Substitutions
;==========================================================================

  #define DDRA  TRISA          ; PIC17Cxxx SFR substitution
  #define DDRB  TRISB          ; PIC17Cxxx SFR substitution
  #define DDRC  TRISC          ; PIC17Cxxx SFR substitution
  #define DDRD  TRISD          ; PIC17Cxxx SFR substitution
  #define DDRE  TRISE          ; PIC17Cxxx SFR substitution



;__CONFIG  _CONFIG1L , _FINTOSC_DIV1_1L   & _DBG_OFF_2L        & _LVREN_ON_1L    & _LVR24V_1L
;__CONFIG  _CONFIG2L , _FLASH_CP1_OFF_2L  & _FLASH_CP0_OFF_2L  & _IDIS_OFF_2L    & _CKSUM_OFF_2L & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L
;__CONFIG  _CONFIG3L , _PSUT_1_3L         & _FCPU_4T_3L        & _WDTE_OFF_3L    & _TWDT_000_3L
;__CONFIG  _CONFIG4L , _OSCM_HIRC_16M_4L  & _MTPDIS_OFF_4L     & _ADCSP_ON_4L



TOSU                         EQU  H'0fff'
TOSH                         EQU  H'0ffe'
TOSL                         EQU  H'0ffd'
STKPTR                       EQU  H'0ffc'
;------- STKPTR  Bits ------------------------------------------------------------
STKFUL                       EQU  H'0007'
STKUNF                       EQU  H'0006'
SP2                          EQU  H'0002'
SP1                          EQU  H'0001'
SP0                          EQU  H'0000'


PCLATU                       EQU  H'0ffb'
PLCATH                       EQU  H'0ffa'
PCL                          EQU  H'0ff9'
TBLPTRU                      EQU  H'0ff8'
TBLPTRH                      EQU  H'0ff7'
TBLPTRL                      EQU  H'0ff6'
TABLAT                       EQU  H'0ff5'
PRODH                        EQU  H'0ff4'
PRODL                        EQU  H'0ff3'


INTCON                       EQU  H'0ff2'
;------- INTCON  Bits ------------------------------------------------------------
GIE                     	EQU  H'0007'
GIEH                    	EQU  H'0007'
GIEL                    	EQU  H'0006'
PEIE                    	EQU  H'0006'


PCON                         EQU  H'0ff1'
;------- PCON  Bits ------------------------------------------------------------
IPEN                         EQU  H'0007'
PB0ST                        EQU  H'0006'
LVDM1                        EQU  H'0005'
LVDM0                        EQU  H'0004'
LVD2                         EQU  H'0002'
LVD1                         EQU  H'0001'
LVD0                         EQU  H'0000'


nan                          EQU  H'0ff0'


INDF                         EQU  H'0fef'


POSTINC0                     EQU  H'0fee'


POSTDEC0                     EQU  H'0fed'


PREINC0                      EQU  H'0fec'
;------- PREINC0  Bits ------------------------------------------------------------


PLUSW0                       EQU  H'0feb'
FSR0H                        EQU  H'0fea'
FSR0L                        EQU  H'0fe9'
WREG                         EQU  H'0fe8'
INDF1                        EQU  H'0fe7'
POSTINC1                     EQU  H'0fe6'
POSTDEC1                     EQU  H'0fe5'
PREINC1                      EQU  H'0fe4'
PLUSW1                       EQU  H'0fe3'
FSR1H                        EQU  H'0fe2'
FSR1L                        EQU  H'0fe1'
BSR                          EQU  H'0fe0'
INDF2                        EQU  H'0fdf'
POSTINC2                     EQU  H'0fde'
POSTDEC2                     EQU  H'0fdd'
PREINC2                      EQU  H'0fdc'
PLUSW2                       EQU  H'0fdb'
FSR2H                        EQU  H'0fda'
FSR2L                        EQU  H'0fd9'
STATUS                       EQU  H'0fd8'
;------- STATUS  Bits ------------------------------------------------------------
N                            EQU  H'0004'
OV                           EQU  H'0003'
Z                            EQU  H'0002'
DC                           EQU  H'0001'
C                            EQU  H'0000'


T0CON                        EQU  H'0fd7'
;------- T0CON0  Bits ------------------------------------------------------------
T0OUT                        EQU  H'0007'
T0CS1                        EQU  H'0006'
T0CS0                        EQU  H'0005'
T0SE                         EQU  H'0004'
PSA                          EQU  H'0003'
PS2                          EQU  H'0002'
PS1                          EQU  H'0001'
PS0                          EQU  H'0000'


PR0                          EQU  H'0fd6'
TMR0                         EQU  H'0fd5'
PWM0DUTY                     EQU  H'0fd4'
PWM0CON                      EQU  H'0fd3'
;------- PWM0CON  Bits ------------------------------------------------------------
POLS_03                      EQU  H'0007'
POLS_02                      EQU  H'0006'
POLS_01                      EQU  H'0005'
POLS_00                      EQU  H'0004'
PWM03EN                      EQU  H'0003'
PWM02EN                      EQU  H'0002'
PWM01EN                      EQU  H'0001'
PWM00EN                      EQU  H'0000'


RCON                         EQU  H'0fd2'
;------- RCON  Bits ------------------------------------------------------------
IRFEN                        EQU  H'0007'
EMCEN                        EQU  H'0006'
RSTF1                        EQU  H'0005'
RSTF0                        EQU  H'0004'
TO                           EQU  H'0003'
PD                           EQU  H'0002'
POR                          EQU  H'0001'
LVR                          EQU  H'0000'


TMR1H                        EQU  H'0fd1'
TMR1L                        EQU  H'0fd0'


T1CON0                       EQU  H'0fcf'
;------- T1CON0  Bits ------------------------------------------------------------
T1CK1                        EQU  H'0007'
T1CK0                        EQU  H'0006'
T1CKPS1                      EQU  H'0005'
T1CKPS0                      EQU  H'0004'
T1SE                         EQU  H'0003'
T1SYNC                       EQU  H'0002'
TMR1CS0                      EQU  H'0001'
TMR1ON                       EQU  H'0000'


T1CON1                       EQU  H'0fce'
;------- T1CON1  Bits ------------------------------------------------------------
INT2EDGE                     EQU  H'0007'
INT1EDGE                     EQU  H'0006'
INT0EDGE                     EQU  H'0005'
T1EDGE                       EQU  H'0004'
T1CH1                        EQU  H'0003'
T1CH0                        EQU  H'0002'
T1M1                         EQU  H'0001'
T1M0                         EQU  H'0000'


TMR2L                        EQU  H'0fcd'
TMR2H                        EQU  H'0fcc'
PR2L                         EQU  H'0fcb'
PR2H                         EQU  H'0fca'


T2CON                        EQU  H'0fc9'
;------- T2CON  Bits ------------------------------------------------------------
PWM2CAEN                     EQU  H'0007'
T2OUTPS3                     EQU  H'0006'
T2OUTPS2                     EQU  H'0005'
T2OUTPS1                     EQU  H'0004'
T2OUTPS0                     EQU  H'0003'
TMR2ON                       EQU  H'0002'
T2CKPS1                      EQU  H'0001'
T2CKPS0                      EQU  H'0000'


CCPR1H                       EQU  H'0fc8'
CCPR1L                       EQU  H'0fc7'
CCPR1LH                      EQU  H'0fc6'
;------- CCPR1LH  Bits ------------------------------------------------------------
T2CAPEN                      EQU  H'0007'


PMS                          EQU  H'0fc5'
;------- PMS  Bits ------------------------------------------------------------
DMISTK2                      EQU  H'0007'
PWMH                         EQU  H'0006'
PMS21                        EQU  H'0005'
PMS20                        EQU  H'0004'
PMS11                        EQU  H'0003'
PMS10                        EQU  H'0002'
PMS01                        EQU  H'0001'
PMS00                        EQU  H'0000'


PXC                          EQU  H'0fc4'
;------- PXC  Bits ------------------------------------------------------------
T3PWMEN                      EQU  H'0007'
T3PWMMODE                    EQU  H'0006'
PXC21                        EQU  H'0005'
PXC20                        EQU  H'0004'
PXC11                        EQU  H'0003'
PXC10                        EQU  H'0002'
PXC01                        EQU  H'0001'
PXC00                        EQU  H'0000'


DTC                          EQU  H'0fc3'
;------- DTC  Bits ------------------------------------------------------------
DTCKS1                       EQU  H'0007'
DTCKS0                       EQU  H'0006'
DTEN                         EQU  H'0005'
DTD4                         EQU  H'0004'
DTD3                         EQU  H'0003'
DTD2                         EQU  H'0002'
DTD1                         EQU  H'0001'
DTD0                         EQU  H'0000'


POLS                         EQU  H'0fc2'
;------- POLS  Bits ------------------------------------------------------------
PT2MODE                      EQU  H'0006'
POLS21                       EQU  H'0005'
POLS20                       EQU  H'0004'
POLS11                       EQU  H'0003'
POLS10                       EQU  H'0002'
POLS01                       EQU  H'0001'
POLS00                       EQU  H'0000'


PME                          EQU  H'0fc1'
;------- PME  Bits ------------------------------------------------------------
PT1MODE                      EQU  H'0007'
PT0MODE                      EQU  H'0006'
PWM2EN1                      EQU  H'0005'
PWM2EN0                      EQU  H'0004'
PWM1EN1                      EQU  H'0003'
PWM1EN0                      EQU  H'0002'
PWM0EN1                      EQU  H'0001'
PWM0EN0                      EQU  H'0000'


PCS                          EQU  H'0fc0'
;------- PCS  Bits ------------------------------------------------------------
PWM21CS                      EQU  H'0003'
PWM20CS                      EQU  H'0002'
PWM11CS                      EQU  H'0001'
PWM10CS                      EQU  H'0000'


CCPCON                       EQU  H'0fbf'
;------- CCPCON  Bits ------------------------------------------------------------
CCP1CH3                      EQU  H'0007'
CCP1CH2                      EQU  H'0006'
CCP1CH1                      EQU  H'0005'
CCP1CH0                      EQU  H'0004'
CCP1M3                       EQU  H'0003'
CCP1M2                       EQU  H'0002'
CCP1M1                       EQU  H'0001'
CCP1M0                       EQU  H'0000'


PWM1CON0                     EQU  H'0fbe'
;------- PWM1CON0  Bits ------------------------------------------------------------
CMPFLT                       EQU  H'0006'
ASTART                       EQU  H'0005'
ACLOSE                       EQU  H'0004'
IOFLT                        EQU  H'0003'
PWMADPOS1                    EQU  H'0002'
PWMADPOS0                    EQU  H'0001'
PWMADEN                      EQU  H'0000'


PWM1CON1                     EQU  H'0fbd'
T3CON                        EQU  H'0fbc'
;------- T3CON  Bits ------------------------------------------------------------
PWM3CAEN                     EQU  H'0007'
T3OUTPS3                     EQU  H'0006'
T3OUTPS2                     EQU  H'0005'
T3OUTPS1                     EQU  H'0004'
T3OUTPS0                     EQU  H'0003'
TMR3ON                       EQU  H'0002'
T3CKPS1                      EQU  H'0001'
T3CKPS0                      EQU  H'0000'


TMR3H                        EQU  H'0fbb'
TMR3L                        EQU  H'0fba'
PR3H                         EQU  H'0fb9'
;------- PR3H  Bits ------------------------------------------------------------


PR3L                         EQU  H'0fb8'
PWM5H                        EQU  H'0fb7'
PWM5L                        EQU  H'0fb6'
PWM4H                        EQU  H'0fb5'
PWM4L                        EQU  H'0fb4'
PWM3H                        EQU  H'0fb3'
PWM3L                        EQU  H'0fb2'
PWM2H                        EQU  H'0fb1'
PWM2L                        EQU  H'0fb0'


PWM2CON0                     EQU  H'0faf'
;------- PWM2CON0  Bits ------------------------------------------------------------
PWM5OEN                      EQU  H'0007'
PWM4OEN                      EQU  H'0006'
PWM3OEN                      EQU  H'0005'
PWM2OEN                      EQU  H'0004'
PWM5EN                       EQU  H'0003'
PWM4EN                       EQU  H'0002'
PWM3EN                       EQU  H'0001'
PWM2EN                       EQU  H'0000'


PWM2CON1                     EQU  H'0fae'
;------- PWM2CON1  Bits ------------------------------------------------------------
POLS5                        EQU  H'0003'
POLS4                        EQU  H'0002'
POLS3                        EQU  H'0001'
POLS2                        EQU  H'0000'


PWM2CON3                     EQU  H'0fad'
;------- PWM2CON3  Bits ------------------------------------------------------------
P5CS1                        EQU  H'0007'
P5CS0                        EQU  H'0006'
P4CS1                        EQU  H'0005'
P4CS0                        EQU  H'0004'
P3CS1                        EQU  H'0003'
P3CS0                        EQU  H'0002'
P2CS1                        EQU  H'0001'
P2CS0                        EQU  H'0000'

ADCMP0H                      EQU  H'0fab'
ADCMP1H                      EQU  H'0faa'
ADCMP01L                     EQU  H'0fa9'
ADRESH                       EQU  H'0fa8'
ADRESL                       EQU  H'0fa7'
ADCON0                       EQU  H'0fa6'
;------- ADCON0  Bits ------------------------------------------------------------
ADFM                         EQU  H'0007'
ADCMPMODE                    EQU  H'0006'
CHS3                         EQU  H'0005'
CHS2                         EQU  H'0004'
CHS1                         EQU  H'0003'
CHS0                         EQU  H'0002'
DONE                         EQU  H'0001'
GO                           EQU  H'0001'
ADON                         EQU  H'0000'


ADCON1                       EQU  H'0fa5'
;------- ADCON1  Bits ------------------------------------------------------------
ADVREF1                      EQU  H'0007'
ADVREF0                      EQU  H'0006'
ACQT2                        EQU  H'0005'
ACQT1                        EQU  H'0004'
ACQT0                        EQU  H'0003'
ADCS2                        EQU  H'0002'
ADCS1                        EQU  H'0001'
ADCS0                        EQU  H'0000'


ADCON2                       EQU  H'0fa4'
;------- ADCON2  Bits ------------------------------------------------------------
ACQT6                        EQU  H'0007'
ACQT5                        EQU  H'0006'
ACQT4                        EQU  H'0005'
ACQT3                        EQU  H'0004'
ANC1                         EQU  H'0003'
ANC0                         EQU  H'0002'
ACFVR                        EQU  H'0001'
ACEN                         EQU  H'0000'


IPR1                         EQU  H'0fa3'
;------- IPR1  Bits ------------------------------------------------------------
ADCMP1IP                     EQU  H'0007'
ADCMP0IP                     EQU  H'0006'
ADIP                         EQU  H'0005'
CCPIP                        EQU  H'0004'
TMR3IP                       EQU  H'0003'
TMR2IP                       EQU  H'0002'
TMR1IP                       EQU  H'0001'
TMR0IP                       EQU  H'0000'


PIR1                         EQU  H'0fa2'
;------- PIR1  Bits ------------------------------------------------------------
ADCMP1IF                     EQU  H'0007'
ADCMP0IF                     EQU  H'0006'
ADIF                         EQU  H'0005'
CCPIF                        EQU  H'0004'
TMR3IF                       EQU  H'0003'
TMR2IF                       EQU  H'0002'
TMR1IF                       EQU  H'0001'
TMR0IF                       EQU  H'0000'


PIE1                         EQU  H'0fa1'
;------- PIE1  Bits ------------------------------------------------------------
ADCMP1IE                     EQU  H'0007'
ADCMP0IE                     EQU  H'0006'
ADIE                         EQU  H'0005'
CCPIE                        EQU  H'0004'
TMR3IE                       EQU  H'0003'
TMR2IE                       EQU  H'0002'
TMR1IE                       EQU  H'0001'
TMR0IE                       EQU  H'0000'


IPR2                         EQU  H'0fa0'
;------- IPR2  Bits ------------------------------------------------------------
PBIP                         EQU  H'0006'
PAIP                         EQU  H'0005'
INT2IP                       EQU  H'0004'
INT1IP                       EQU  H'0003'
INT0IP                       EQU  H'0002'
LVDIP                        EQU  H'0001'
CMPIP                        EQU  H'0000'


PIR2                         EQU  H'0f9f'
;------- PIR2  Bits ------------------------------------------------------------
PBIF                         EQU  H'0006'
PAIF                         EQU  H'0005'
INT2IF                       EQU  H'0004'
INT1IF                       EQU  H'0003'
INT0IF                       EQU  H'0002'
LVDIF                        EQU  H'0001'
CMPIF                        EQU  H'0000'


PIE2                         EQU  H'0f9e'
;------- PIE2  Bits ------------------------------------------------------------
PBIE                         EQU  H'0006'
PAIE                         EQU  H'0005'
INT2IE                       EQU  H'0004'
INT1IE                       EQU  H'0003'
INT0IE                       EQU  H'0002'
LVDIE                        EQU  H'0001'
CMPIE                        EQU  H'0000'


SMTB                         EQU  H'0f99'
;------- SMTB  Bits ------------------------------------------------------------
PB7SMT                       EQU  H'0007'
PB6SMT                       EQU  H'0006'
PB5SMT                       EQU  H'0005'
PB4SMT                       EQU  H'0004'
PB3SMT                       EQU  H'0003'
PB2SMT                       EQU  H'0002'
PB1SMT                       EQU  H'0001'
PB0SMT                       EQU  H'0000'


SMTA                         EQU  H'0f98'
;------- SMTA  Bits ------------------------------------------------------------
PA5SMT                       EQU  H'0005'
PA4SMT                       EQU  H'0004'
PA3SMT                       EQU  H'0003'
PA2SMT                       EQU  H'0002'
PA1SMT                       EQU  H'0001'
PA0SMT                       EQU  H'0000'



PBOD                         EQU  H'0f95'
;------- PBOD  Bits ------------------------------------------------------------
PB7OD                        EQU  H'0007'
PB6OD                        EQU  H'0006'
PB5OD                        EQU  H'0005'
PB4OD                        EQU  H'0004'
PB3OD                        EQU  H'0003'
PB2OD                        EQU  H'0002'
PB1OD                        EQU  H'0001'
PB0OD                        EQU  H'0000'


PAOD                         EQU  H'0f94'
;------- PAOD  Bits ------------------------------------------------------------
PA5OD                        EQU  H'0005'
PA4OD                        EQU  H'0004'
PA3OD                        EQU  H'0003'
PA2OD                        EQU  H'0002'
PA1OD                        EQU  H'0001'
PA0OD                        EQU  H'0000'


TRISB                        EQU  H'0f91'
;------- TRISB  Bits ------------------------------------------------------------
TRISB7                       EQU  H'0007'
TRISB6                       EQU  H'0006'
TRISB5                       EQU  H'0005'
TRISB4                       EQU  H'0004'
TRISB3                       EQU  H'0003'
TRISB2                       EQU  H'0002'
TRISB1                       EQU  H'0001'
TRISB0                       EQU  H'0000'


TRISA                        EQU  H'0f90'
;------- TRISA  Bits ------------------------------------------------------------
TRISA5                       EQU  H'0005'
TRISA4                       EQU  H'0004'
TRISA3                       EQU  H'0003'
TRISA2                       EQU  H'0002'
TRISA1                       EQU  H'0001'
TRISA0                       EQU  H'0000'



PBPD                         EQU  H'0f8d'
;------- PBPD  Bits ------------------------------------------------------------
PB7PD                        EQU  H'0007'
PB6PD                        EQU  H'0006'
PB5PD                        EQU  H'0005'
PB4PD                        EQU  H'0004'
PB3PD                        EQU  H'0003'
PB2PD                        EQU  H'0002'
PB1PD                        EQU  H'0001'
PB0PD                        EQU  H'0000'


PAPD                         EQU  H'0f8c'
;------- PAPD  Bits ------------------------------------------------------------
PA5PD                        EQU  H'0005'
PA4PD                        EQU  H'0004'
PA3PD                        EQU  H'0003'
PA2PD                        EQU  H'0002'
PA1PD                        EQU  H'0001'
PA0PD                        EQU  H'0000'




PINB                         EQU  H'0f89'
PINA                         EQU  H'0f88'


PBPU                         EQU  H'0f85'
;------- PBPU  Bits ------------------------------------------------------------
PB7PU                        EQU  H'0007'
PB6PU                        EQU  H'0006'
PB5PU                        EQU  H'0005'
PB4PU                        EQU  H'0004'
PB3PU                        EQU  H'0003'
PB2PU                        EQU  H'0002'
PB1PU                        EQU  H'0001'
PB0PU                        EQU  H'0000'


PAPU                         EQU  H'0f84'
;------- PAPU  Bits ------------------------------------------------------------
PA5PU                        EQU  H'0005'
PA4PU                        EQU  H'0004'
PA3PU                        EQU  H'0003'
PA2PU                        EQU  H'0002'
PA1PU                        EQU  H'0001'
PA0PU                        EQU  H'0000'


PORTB                        EQU  H'0f81'
;------- PORTB  Bits ------------------------------------------------------------
PB7                          EQU  H'0007'
PB6                          EQU  H'0006'
PB5                          EQU  H'0005'
PB4                          EQU  H'0004'
PB3                          EQU  H'0003'
PB2                          EQU  H'0002'
PB1                          EQU  H'0001'
PB0                          EQU  H'0000'


PORTA                        EQU  H'0f80'
;------- PORTA  Bits ------------------------------------------------------------
PA5                          EQU  H'0005'
PA4                          EQU  H'0004'
PA3                          EQU  H'0003'
PA2                          EQU  H'0002'
PA1                          EQU  H'0001'
PA0                          EQU  H'0000'






CMPCON0                      EQU  H'0f78'
;------- CMPCON0  Bits ------------------------------------------------------------
CMPEN                        EQU  H'0007'
CMPPOS                       EQU  H'0006'
CMPPCH2                      EQU  H'0005'
CMPPCH1                      EQU  H'0004'
CMPPCH0                      EQU  H'0003'
CMPNCH2                      EQU  H'0002'
CMPNCH1                      EQU  H'0001'
CMPNCH0                      EQU  H'0000'


CMPCON1                      EQU  H'0f77'
;------- CMPCON1  Bits ------------------------------------------------------------
CMP_HYSEN                    EQU  H'0007'
HYS_VOL1                     EQU  H'0005'
HYS_VOL0                     EQU  H'0004'
CMPOUT                       EQU  H'0000'


CMPCON2                      EQU  H'0f76'
;------- CMPCON2  Bits ------------------------------------------------------------
CMPFILTER3                   EQU  H'0007'
CMPFILTER2                   EQU  H'0006'
CMPFILTER1                   EQU  H'0005'
CMPFILTER0                   EQU  H'0004'
C0OUT3EN                     EQU  H'0003'
C0OUT2EN                     EQU  H'0002'
C0OUT1EN                     EQU  H'0001'
C0OUT0EN                     EQU  H'0000'

DACCON                       EQU  H'0f74'
;------- DACCON  Bits ------------------------------------------------------------
DACVREF                      EQU  H'0007'
DACEN                        EQU  H'0006'
DACS5                        EQU  H'0005'
DACS4                        EQU  H'0004'
DAC3                         EQU  H'0003'
DAC2                         EQU  H'0002'
DAC1                         EQU  H'0001'
DAC0                         EQU  H'0000'


FVRCON0                      EQU  H'0f72'
;------- FVRCON0  Bits ------------------------------------------------------------
FVR_A2D_OUT                  EQU  H'0007'
FVROUTEN                     EQU  H'0006'
FVREN                        EQU  H'0005'
FVRPGA1                      EQU  H'0004'
FVRPGA0                      EQU  H'0003'
FVR_SEL2                     EQU  H'0002'
FVR_SEL1                     EQU  H'0001'
FVR_SEL0                     EQU  H'0000'


FVRCON1                      EQU  H'0f71'
;------- FVRCON1  Bits ------------------------------------------------------------
FVR_OFFSET_EN                EQU  H'0005'


LCDCON0                      EQU  H'0f70'
;------- LCDCON0  Bits ------------------------------------------------------------
LCDEN                        EQU  H'0007'
LCDCSEL1                     EQU  H'0001'
LCDCSEL0                     EQU  H'0000'


LCDCON1                      EQU  H'0f6f'
;------- LCDCON1  Bits ------------------------------------------------------------
COM7EN                       EQU  H'0007'
COM6EN                       EQU  H'0006'
COM5EN                       EQU  H'0005'
COM4EN                       EQU  H'0004'
COM3EN                       EQU  H'0003'
COM2EN                       EQU  H'0002'
COM1EN                       EQU  H'0001'
COM0EN                       EQU  H'0000'


LCDCON2                      EQU  H'0f6e'
;------- LCDCON2  Bits ------------------------------------------------------------
COM13EN                      EQU  H'0005'
COM12EN                      EQU  H'0004'
COM11EN                      EQU  H'0003'
COM10EN                      EQU  H'0002'
COM9EN                       EQU  H'0001'
COM8EN                       EQU  H'0000'




IAPTRIG                      EQU  H'0f6c'
IAPCTRL                      EQU  H'0f6b'
;------- IAPCTRL  Bits ------------------------------------------------------------
ERR                          EQU  H'0003'
LOCK                         EQU  H'0002'
ER                           EQU  H'0001'
PG                           EQU  H'0000'


IAPADDRH                     EQU  H'0f6a'
IAPADDRL                     EQU  H'0f69'
IAPDATH                      EQU  H'0f68'
IAPDATL                      EQU  H'0f67'
IAPWAIT                      EQU  H'0f66'


SMCR                         EQU  H'0f65'
;------- SMCR  Bits ------------------------------------------------------------
SM2                          EQU  H'0003'
SM1                          EQU  H'0002'
SM0                          EQU  H'0001'
SE                           EQU  H'0000'


OSCCON                       EQU  H'0f64'
;------- OSCCON  Bits ------------------------------------------------------------
PLL                          EQU  H'0007'
FINTOSC2                     EQU  H'0006'
FINTOSC1                     EQU  H'0005'
FINTOSC0                     EQU  H'0004'
CKOE1                        EQU  H'0003'
CKOE0                        EQU  H'0002'
OSCF                         EQU  H'0001'
OSCM                         EQU  H'0000'


SIGCON                       EQU  H'0f63'
;------- SIGCON  Bits ------------------------------------------------------------
ICE_TMEREN                   EQU  H'0007'
SIGS                         EQU  H'0000'


CLKCFG1                      EQU  H'0f62'
;------- CLKCFG1  Bits ------------------------------------------------------------
CMPCLKEN                     EQU  H'0007'
DACCLKEN                     EQU  H'0006'
ADCCLKEN                     EQU  H'0005'
CCPCLKEN                     EQU  H'0004'
T3CLKEN                      EQU  H'0003'
T2CLKEN                      EQU  H'0002'
T1CLKEN                      EQU  H'0001'
T0CLKEN                      EQU  H'0000'



PAINTMASK                    EQU  H'0f60'
;------- PAINTMASK  Bits ------------------------------------------------------------
PAINTMASK5                   EQU  H'0005'
PAINTMASK4                   EQU  H'0004'
PAINTMASK3                   EQU  H'0003'
PAINTMASK2                   EQU  H'0002'
PAINTMASK1                   EQU  H'0001'
PAINTMASK0                   EQU  H'0000'


PBINTMASK                    EQU  H'0f5f'
;------- PBINTMASK  Bits ------------------------------------------------------------
PBINTMASK7                   EQU  H'0007'
PBINTMASK6                   EQU  H'0006'
PBINTMASK5                   EQU  H'0005'
PBINTMASK4                   EQU  H'0004'
PBINTMASK3                   EQU  H'0003'
PBINTMASK2                   EQU  H'0002'
PBINTMASK1                   EQU  H'0001'
PBINTMASK0                   EQU  H'0000'




WDTCON                       EQU  H'0f58'
;------- WDTCON  Bits ------------------------------------------------------------
PREDIV2                      EQU  H'0003'
PREDIV1                      EQU  H'0002'
PREDIV0                      EQU  H'0001'
WDTEN                        EQU  H'0000'


CURCON                       EQU  H'0f55'
;------- CURCON  Bits ------------------------------------------------------------
PBCUR                        EQU  H'0003'
PACUR                        EQU  H'0002'
PA2CUR                       EQU  H'0001'
PA1CUR                       EQU  H'0000'


ANASEL0                      EQU  H'0f54'
;------- ANASEL0  Bits ------------------------------------------------------------
PA5AEN                       EQU  H'0005'
PA4AEN                       EQU  H'0004'
PA3AEN                       EQU  H'0003'
PA2AEN                       EQU  H'0002'
PA1AEN                       EQU  H'0001'
PA0AEN                       EQU  H'0000'


ANASEL1                      EQU  H'0f53'
;------- ANASEL1  Bits ------------------------------------------------------------
PB7AEN                       EQU  H'0007'
PB6AEN                       EQU  H'0006'
PB5AEN                       EQU  H'0005'
PB4AEN                       EQU  H'0004'
PB3AEN                       EQU  H'0003'
PB2AEN                       EQU  H'0002'
PB1AEN                       EQU  H'0001'
PB0AEN                       EQU  H'0000'


;==========================================================================
;
;       RAM Definition
;
;==========================================================================

        __MAXRAM H'FFF'
    __BADRAM H'200'-H'F7F'
        __BADRAM H'F85'-H'F88'
        __BADRAM H'F8E'-H'F91'
        __BADRAM H'F97'-H'F9C'
        __BADRAM H'FA3'-H'FA5'
        __BADRAM H'FAA'
        __BADRAM H'FB4'-H'FB9'


;==========================================================================
;
;   IMPORTANT: For the XAD16810 devices, the __CONFIG directive has been
;              superseded by the CONFIG directive.  The following settings
;              are available for this device.
;
;
;==========================================================================
;==========================================================================
;
;       Configuration Bits
;
;     Data Sheet    Include File                  Address
;     CONFIG1L    = Configuration Byte 1L         300000h
;     CONFIG1H    = Configuration Byte 1H         300001h
;     CONFIG2L    = Configuration Byte 2L         300002h
;     CONFIG2H    = Configuration Byte 2H         300003h
;     CONFIG3L    = Configuration Byte 3L         300004h
;     CONFIG3H    = Configuration Byte 3H         300005h
;     CONFIG4L    = Configuration Byte 4L         300006h
;     CONFIG4H    = Configuration Byte 4H         300007h
;     CONFIG5L    = Configuration Byte 5L         300008h
;     CONFIG5H    = Configuration Byte 5H         300009h
;     CONFIG6L    = Configuration Byte 6L         30000ah
;     CONFIG6H    = Configuration Byte 6H         30000bh
;     CONFIG7L    = Configuration Byte 7L         30000ch
;     CONFIG7H    = Configuration Byte 7H         30000dh
;
;==========================================================================

;Configuration Byte 1L Options
_LVR24V_1L          EQU  H'FFF0' ;LVR-out Reset set to 2.4V
_LVR27V_1L          EQU  H'FFF1' ;LVR-out Reset set to 2.7V
_LVR30V_1L          EQU  H'FFF2' ;LVR-out Reset set to 3.0V
_LVR33V_1L          EQU  H'FFF3' ;LVR-out Reset set to 3.3V
_LVR36V_1L          EQU  H'FFF4' ;LVR-out Reset set to 3.6V
_LVR38V_1L          EQU  H'FFF5' ;LVR-out Reset set to 3.8V
_LVR42V_1L          EQU  H'FFF6' ;LVR-out Reset set to 4.2V
_LVR43V_1L          EQU  H'FFF7' ;LVR-out Reset set to 4.3V


_LVREN_ON_1L        EQU  H'FFFF' ;  Enable LVR reset
_LVREN_OFF_1L       EQU  H'FFEF' ;  Disenable LVR reset


_DBG_ON_2L          EQU  H'FFFF'  ; DEBUG mode  ENABLE
_DBG_OFF_2L         EQU  H'FFFE'  ; DEBUG mode  DISENABLE

_FINTOSC_DIV1_1L    EQU  H'FFFF' ; Fosc DIVIDER 1:1
_FINTOSC_DIV2_1L    EQU  H'FFDF' ; Fosc DIVIDER 1:2
_FINTOSC_DIV4_1L    EQU  H'FFBF' ; Fosc DIVIDER 1:4
_FINTOSC_DIV8_1L    EQU  H'FF9F' ; Fosc DIVIDER 1:8
_FINTOSC_DIV16_1L   EQU  H'FF5F' ; Fosc DIVIDER 1:16


;Configuration Byte 2L Options

 _STV_OFF_2L              EQU  H'FFFE'		; Stack overflow reset disenable
 _STV_ON_2L               EQU  H'FFFF'		; Stack overflow reset enable

 _RSEL_HIGH_2L            EQU  H'FFFD'		;   pullup 100K,pulldown 300K
 _RSEL_LOW_2L             EQU  H'FFFF'		;   pullup 30K, pulldown 30K

 _RESETE_ON_2L            EQU  H'FFFF'		;  Reset Pin enable
 _RESETE_OFF_2L           EQU  H'FFFB'		;  Reset Pin disable

 _CBP_ON_2L               EQU  H'FFFF'		;  Program code encrypte enable
 _CBP_OFF_2L              EQU  H'FFF7'		;  Program code encrypte disenable

 _CKSUM_OFF_2L            EQU  H'FFEF'		;  cksum  disenable
 _CKSUM_ON_2L             EQU  H'FFFF'		;  cksum  enable

 _IDIS_OFF_2L             EQU  H'FFDF'		;	Read  data is always 0
 _IDIS_ON_2L              EQU  H'FFFF'		;   Normal read data

 _FLASH_CP0_ON_2L         EQU  H'FFFF'		;   flash space 0-1k protect enbale
 _FLASH_CP0_OFF_2L        EQU  H'FFBF'		;   flash space 0-1k protect disenable

 _FLASH_CP1_ON_2L         EQU  H'FFFF'		;   flash space 1k-2k protect enbale
 _FLASH_CP1_OFF_2L        EQU  H'FF7F'		;   flash space 1k-2k protect disenable


;Configuration Byte 3L Options

_TWDT_111_3L              EQU H'FFFF'		; WDT overflow time 8.32s
_TWDT_110_3L              EQU H'FFFE'		; WDT overflow time 4.224s
_TWDT_101_3L              EQU H'FFFD'		; WDT overflow time 2.176s
_TWDT_100_3L              EQU H'FFFC'		; WDT overflow time 1.152s
_TWDT_011_3L              EQU H'FFFB'		; WDT overflow time 640ms
_TWDT_010_3L              EQU H'FFFA'		; WDT overflow time 384ms
_TWDT_001_3L              EQU H'FFF9'		; WDT overflow time 256ms
_TWDT_000_3L              EQU H'FFF8'		; WDT overflow time 128ms

_WDTE_OFF_3L              EQU H'FFF7'		;   WDT disenabled
_WDTE_ON_3L               EQU H'FFFF'		;   WDT enabled

_FCPU_4T_3L               EQU H'FFFF'		;   4 Instruction cycle
_FCPU_2T_3L               EQU H'FFEF'		;   2 Instruction cycle

_PSUT_8_3L                EQU H'FF7F'		;  Power on delay  18.55ms
_PSUT_4_3L                EQU H'FF5F'		;  Power on delay  288.55ms
_PSUT_2_3L                EQU H'FF3F'		;  Power on delay  864.55ms
_PSUT_1_3L                EQU H'FF1F'		;  Power on delay  1.05ms

;Configuration Byte 4L Options
_ADCSP_OFF_4L            EQU H'FF82'    ; ADC low speed
_ADCSP_ON_4L             EQU H'FF83'    ; ADC high speed

_MTPDIS_OFF_4L           EQU H'FF81'    ; disenable read MTP control in SWD mode
_MTPDIS_ON_4L            EQU H'FF83'    ; Enable read MTP control in SWD mode

_OSCM_HIRC_16M_4L      	 EQU H'FF83'    ; HIRC(16MHZ) AS MAIN CLOCK
_OSCM_LIRC_2K_4L         EQU H'FF03'    ; LIRC(2KHZ) AS MAIN CLOCK


; To use the Configuration Bits, place the following lines in your source code
;  in the following format, and change the configuration value to the desired
;  setting (such as CP_OFF to CP_ON).  These are currently commented out here
;  and each __CONFIG line should have the preceding semicolon removed when
;  pasted into your source code.

;  The following is a assignment of address values for all of the configuration
;  registers for the purpose of table reads
_CONFIG1L         EQU    H'300000'
_CONFIG1H         EQU    H'300001'
_CONFIG2L         EQU    H'300002'
_CONFIG2H         EQU    H'300003'
_CONFIG3L         EQU    H'300004'
_CONFIG3H         EQU    H'300005'
_CONFIG4L         EQU    H'300006'
_CONFIG4H         EQU    H'300007'
_CONFIG5L         EQU    H'300008'
_CONFIG5H         EQU    H'300009'
;_CONFIG6L        EQU    H'30000A'
;_CONFIG6H        EQU    H'30000B'
;_CONFIG7L        EQU    H'30000C'
;_CONFIG7H        EQU    H'30000D'
;_DEVID1          EQU    H'3FFFFE'
;_DEVID2          EQU    H'3FFFFF'
;_IDLOC0          EQU    H'200000'
;_IDLOC1          EQU    H'200001'
;_IDLOC2          EQU    H'200002'
;_IDLOC3          EQU    H'200003'
;_IDLOC4          EQU    H'200004'
;_IDLOC5          EQU    H'200005'
;_IDLOC6          EQU    H'200006'
;_IDLOC7          EQU    H'200007'

;Program Configuration Register 1H
;		__CONFIG    _CONFIG1H, _OSCS_OFF_1H & _RCIO_OSC_1H

;Program Configuration Register 2L
;		__CONFIG    _CONFIG2L, _BOR_ON_2L & _BORV_20_2L & _PWRT_OFF_2L

;Program Configuration Register 2H
;		__CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_128_2H

;Program Configuration Register 3H
;		__CONFIG    _CONFIG3H, _CCP2MX_ON_3H

;Program Configuration Register 4L
;		__CONFIG    _CONFIG4L, _STVR_ON_4L & _LVP_OFF_4L & _DEBUG_OFF_4L

;Program Configuration Register 5L
;		__CONFIG    _CONFIG5L, _CP0_OFF_5L & _CP1_OFF_5L & _CP2_OFF_5L & _CP3_OFF_5L

;Program Configuration Register 5H
;		__CONFIG    _CONFIG5H, _CPB_ON_5H & _CPD_OFF_5H

;Program Configuration Register 6L
;		__CONFIG    _CONFIG6L, _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L

;Program Configuration Register 6H
;		__CONFIG    _CONFIG6H, _WRTC_OFF_6H & _WRTB_OFF_6H & _WRTD_OFF_6H

;Program Configuration Register 7L
;		__CONFIG    _CONFIG7L, _EBTR0_OFF_7L & _EBTR1_OFF_7L & _EBTR2_OFF_7L & _EBTR3_OFF_7L

;Program Configuration Register 7H
;		__CONFIG    _CONFIG7H, _EBTRB_OFF_7H

;ID Locations Register 0
;		__IDLOCS    _IDLOC0, <expression>

;ID Locations Register 1
;		__IDLOCS    _IDLOC1, <expression>

;ID Locations Register 2
;		__IDLOCS    _IDLOC2, <expression>

;ID Locations Register 3
;		__IDLOCS    _IDLOC3, <expression>

;ID Locations Register 4
;		__IDLOCS    _IDLOC4, <expression>

;ID Locations Register 5
;		__IDLOCS    _IDLOC5, <expression>

;ID Locations Register 6
;		__IDLOCS    _IDLOC6, <expression>

;ID Locations Register 7
;		__IDLOCS    _IDLOC7, <expression>

;Device ID registers hold device ID and revision number and can only be read
;Device ID Register 1
;               DEV2, DEV1, DEV0, REV4, REV3, REV2, REV1, REV0
;Device ID Register 2
;               DEV10, DEV9, DEV8, DEV7, DEV6, DEV5, DEV4, DEV3

        LIST
